/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.util;

import DE.siemens.ad.logo.util.Language;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.filechooser.FileFilter;

public class LogoFileFilter
extends FileFilter {
    private static String TYPE_UNKNOWN = "Type Unknown";
    private static String HIDDEN_FILE = "Hidden File";
    private Hashtable filters = null;
    private String description = null;
    private String fullDescription = null;
    private boolean useExtensionsInDescription = true;

    public LogoFileFilter() {
        this.filters = new Hashtable();
        this.addExtension("lsc");
        this.addExtension("lgo");
        this.setDescription("LOGOSoft " + Language.getString("dialog.fileChooser.files", "Files"));
    }

    public LogoFileFilter(String[] filters) {
        this(filters, null);
    }

    public LogoFileFilter(String[] filters, String description) {
        for (int i = 0; i < filters.length; ++i) {
            this.addExtension(filters[i]);
        }
        if (description != null) {
            this.setDescription(description);
        }
    }

    public LogoFileFilter(String extension) {
        this(extension, null);
    }

    public LogoFileFilter(String extension, String description) {
        if (this.filters == null) {
            this.filters = new Hashtable();
        }
        if (extension != null) {
            this.addExtension(extension);
        }
        if (description != null) {
            this.setDescription(description);
        }
    }

    public boolean accept(File f) {
        if (f != null) {
            if (f.isDirectory()) {
                return true;
            }
            String extension = this.getExtension(f);
            if (extension != null && this.filters.get(this.getExtension(f)) != null) {
                return true;
            }
        }
        return false;
    }

    public void addExtension(String extension) {
        if (this.filters == null) {
            this.filters = new Hashtable(5);
        }
        this.filters.put(extension.toLowerCase(), this);
        this.fullDescription = null;
    }

    public String getDescription() {
        if (this.fullDescription == null) {
            if (this.description == null || this.isExtensionListInDescription()) {
                this.fullDescription = this.description == null ? "(" : this.description + " (";
                Enumeration extensions = this.filters.keys();
                if (extensions != null) {
                    this.fullDescription = this.fullDescription + "." + (String)extensions.nextElement();
                    while (extensions.hasMoreElements()) {
                        this.fullDescription = this.fullDescription + ", ." + (String)extensions.nextElement();
                    }
                }
                this.fullDescription = this.fullDescription + ")";
            } else {
                this.fullDescription = this.description;
            }
        }
        return this.fullDescription;
    }

    public String getExtension(File f) {
        String filename;
        int i;
        if (f != null && (i = (filename = f.getName()).lastIndexOf(46)) > 0 && i < filename.length() - 1) {
            return filename.substring(i + 1).toLowerCase();
        }
        return null;
    }

    public String[] getExtensions() {
        String[] ret = null;
        Enumeration extensions = this.filters.keys();
        Vector zw = new Vector();
        if (extensions != null) {
            while (extensions.hasMoreElements()) {
                zw.add(extensions.nextElement());
            }
            ret = new String[zw.size()];
            for (int i = 0; i < zw.size(); ++i) {
                ret[i] = (String)zw.elementAt(i);
            }
        }
        return ret;
    }

    public boolean isExtensionListInDescription() {
        return this.useExtensionsInDescription;
    }

    public void removeExtension(String extension) {
        if (this.filters == null) {
            return;
        }
        if (this.filters.contains(extension.toLowerCase())) {
            this.filters.remove(extension.toLowerCase());
        }
    }

    public void setDescription(String description) {
        this.description = description;
        this.fullDescription = null;
    }

    public void setExtensionListInDescription(boolean b) {
        this.useExtensionsInDescription = b;
        this.fullDescription = null;
    }

    public String toString() {
        return "FileFilter:" + this.getDescription();
    }
}

